function Chapter9
close all % close all open figures
clc % clear the command window

% 9.4.2
% Highlight
A = imread('Cars2.jpg');
r = A(:,:,1); g = A(:,:,2); b = A(:,:,3);
figure, imshow(A)
waitforbuttonpress
t = get(gca,'CurrentPoint');
% create mask
[x,y] = meshgrid(1:size(r,2),1:size(r,1));
ra = 600; % radius of the region of interest
mask = (x-t(1,1)).^2 + (y-t(1,2)).^2 < ra^2;
r(~mask) = r(~mask)*0.5;
g(~mask) = g(~mask)*0.5;
b(~mask) = b(~mask)*0.5;
B = uint8(cat(3,r,g,b));
figure,imshow(B)

% 9.4.4
% Squares in loop
k = 10;
co = rand(k,3);
figure, hold on, axis equal off
for j = 1:30
    for i = 1:k
        w = k-i+1;
        fill([w,w,-w,-w],[-w,w,w,-w],co(i,:))
    end
    co(1,:) = [];
    co = [co;rand(1,3)];
    pause(0.1)
end


% 9.4.6
% Stopwatch
S = input('Number of seconds? ---> ');
figure('color','y')
hold on
text(-0.10,0.95,'Stopwatch','FontName','Tempus Sans ITC','Fontsize',20);
t = text(0.2,0.5,'0','FontName','Tempus Sans ITC','Fontsize',140);
axis off
for i = 1:S
    set(t,'String',num2str(i))
    pause(0.98)
end

% 9.4.8
% Planets
figure, hold on
plot(0,0,'y.','markersize',80) % the sun
theta = linspace(0,2*pi,100);
r1 = 1; % radius of orbit1
r2 = 3; % radius of orbit2
% Orbit trajectories
plot(sin(theta)*r1,cos(theta)*r1,'k--')
plot(sin(theta)*r2,cos(theta)*r2,'k--')
theta1 = linspace(0,4*pi,250);
theta2 = linspace(0,4*pi,500);
h1 = plot(0,1,'r.','markersize',50); % planet 1 (inner)
h2 = plot(0,3,'b.','markersize',40); % planet 2 (outer)
h3 = plot(sin(theta)*0.8,cos(theta)*0.8+r2,'k--'); % orbit of moon
h4 = plot(sin(theta(30))*0.8,cos(theta(30))*0.8+r2,'k.',...
    'markersize',30); % moon of planet 2
axis([-4 4 -4 4])
axis square off
for i = 1:500
    set(h1,'Xdata',r1*sin(theta1(mod(i,250)+1)),...
        'Ydata',r1*cos(theta1(mod(i,250)+1)))
    set(h2,'Ydata',r2*sin(theta2(mod(i,500)+1)),...
        'Xdata',r2*cos(theta2(mod(i,500)+1)))
    set(h3,'Ydata',r2*sin(theta2(mod(i,500)+1))+cos(theta)*0.8,...
        'Xdata',r2*cos(theta2(mod(i,500)+1))+sin(theta)*0.8)
    % fixed moon
    %     set(h4,'Ydata',r2*sin(theta2(mod(i,500)+1))+cos(theta(30))*0.8,...
    %         'Xdata',r2*cos(theta2(mod(i,500)+1))+sin(theta(30))*0.8)
    % orbiting moon
    set(h4,'Ydata',r2*sin(theta2(mod(i,500)+1))+cos(theta2(i))*0.8,...
        'Xdata',r2*cos(theta2(mod(i,500)+1))+sin(theta2(i))*0.8)
    pause(0.02)
end


% 9.4.10
% Umbrella
% (a) Function is further down
% (b) The extended function further down
% (c) 
figure
draw_sectors(20,[0.3 0.2 0.8])
draw_sectors_BW(20,[0.3 0.2 0.8],0)
draw_sectors_BW(20,[0.6 0.9 0.1],0)
while true
    waitforbuttonpress
    if gco == gcf
        delete(gco)
        break
    else
        coo = get(gco,'FaceColor');
        set(gco,'FaceColor',1-coo)
    end
end


% 9.4.12
% Rotating square
figure, hold on
fill([-1 1 1 -1],[-1 -1 1 1],'w'); % white square
fill([0 1 1 0],[0 0 1 1],'r'); % red square
h = fill([0 0.5 0.5 0],[0 0 0.5 0.5],'k'); % black square
fill([0 0.25 0.25 0],[0 0 0.25 0.25],[0.7 0.7 0.7]); % grey square
axis square off
plot([-1 1],[0 0],'k-')
plot([0 0],[-1 1],'k-')
theta = 2*pi/100;
R = [cos(theta) sin(theta); -sin(theta) cos(theta)]; % rotation matrix
for i = 1:100 % rotate the black square
    X1 = get(h,'XData');
    Y1 = get(h,'YData');
    NewPoints = R * [X1(:)';Y1(:)']; % incremental rotation
    set(h,'XData',NewPoints(1,:),'YData',NewPoints(2,:))
    pause (0.05)
end



% 9.4.14
% Jumping frog
figure, hold on
axis([0 1 0 1])
fill([0 1 1 0],[0 0 1 1],'b','edgecolor','b') % pond
axis square off
f = fill([0.47 0.53 0.5],[0.47 0.47 0.53],'g','edgecolor','g'); % frog
oldx = 0.5; oldy = 0.5;
for i = 1:15 % 15 jumps
    x = rand; y = rand; % new position
    X = [x-0.03,x+0.03,x]; % frog coordinates
    Y = [y-0.03,y-0.03,y+0.03];
    set(f,'XData',X,'YData',Y); % update frog position
    plot([oldx,x],[oldy,y],'g--') % plot the trace
    oldx = x; oldy = y; % save the current point as "old"
    pause(0.5)
end


% 9.4.16
% scrambled eggs
A = imread('Eggs.jpg'); % the original image
M = 4; % rows
N = 5; % columns
Rows = floor(size(A,1)/M); % Tile size - rows
Columns = floor(size(A,2)/N); % Tile size - columns
A = A(1:M*Rows,1:N*Columns,:); % reduce the image to match
RP = randperm(M*N); % shuffle index
Tiles = mat2cell(A,ones(1,M)*Rows, ones(1,N)*Columns,3);
Tiles = reshape(Tiles(RP),M,N);
B = cell2mat(Tiles); % shuffled image
RepeatedRP = randperm(M*N);
Tiles(RepeatedRP(2)) = Tiles(RepeatedRP(1));
C = cell2mat(Tiles);
% calculate the dark image
DarkTiles = mat2cell(A*0.3,ones(1,M)*Rows, ones(1,N)*Columns,3);
DarkTiles(RepeatedRP(2)) = Tiles(RepeatedRP(2));
DarkTiles(RepeatedRP(1)) = Tiles(RepeatedRP(2));
D = cell2mat(DarkTiles);
figure
subplot(2,2,1), imshow(A)
set(gca,'FontName','Candara','FontSize',12)
title('Original image')
subplot(2,2,2), imshow(B)
set(gca,'FontName','Candara','FontSize',12)
title('Scrambled eggs')
subplot(2,2,3), imshow(C)
set(gca,'FontName','Candara','FontSize',12)
title('Repeated tile')
pause(3)
subplot(2,2,4), imshow(D)
set(gca,'FontName','Candara','FontSize',12)
title('Reveal')
end

%--------------------------------------------------------------------------
function draw_sectors(N,Co)
figure
hold on
axis([-1 1 -1 1])
axis square off
theta = linspace(0,2*pi,N+1);
r = linspace(1,Co(1),N);
g = linspace(1,Co(2),N);
b = linspace(1,Co(3),N);
for i = 1:N
    fill([0 cos(theta(i)) cos(theta(i+1)) 0],...
        [0 sin(theta(i)) sin(theta(i+1)) 0], [r(i),g(i),b(i)])
    pause(0.1)
end
end

function draw_sectors_BW(N,Co,bw)
figure
hold on
axis([-1 1 -1 1])
axis square off
theta = linspace(0,2*pi,N+1);
r = linspace(bw,Co(1),N);
g = linspace(bw,Co(2),N);
b = linspace(bw,Co(3),N);
for i = 1:N
    fill([0 cos(theta(i)) cos(theta(i+1)) 0],...
        [0 sin(theta(i)) sin(theta(i+1)) 0], [r(i),g(i),b(i)])
    pause(0.1)
end
end

