function Chapter8
close all % close all open figures
clc % clear the command window

% 8.4.2
% House
House =[
    0   0	0	0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	1	1	0	0	0	0	0	0	0
    0	0	0	0	0	1	1	1	1	0	0	0	0	0	0
    0	0	0	0	1	1	1	1	1	1	0	0	0	0	0
    0	0	0	1	1	1	1	1	1	1	1	0	0	0	0
    0	0	0	0	3	3	3	3	3	3	0	0	0	0	0
    2	2	2	2	3	4	3	3	3	3	2	2	2	2	2
    2	2	2	2	3	4	3	4	4	3	2	2	2	2	2
    2	2	2	2	3	3	3	4	4	3	2	2	2	2	2
    2	2	2	2	3	3	3	4	4	3	2	2	2	2	2
    ];
house = [
    0 0 1 % blue
    1 0 0 % red
    0 1 0 % green
    0.8 0.8 0.8 % grey
    0 0 0 % black
    ];
f = figure;
imagesc(House);
colormap(house)
axis equal off



% 8.4.4
% Baby C histograms
A = imread('BabyC.jpg');
ti = {'Red','Green','Blue'};
figure
for i = 1:3
    subplot(3,1,i)
    p = A(:,:,i); hist(double(p(:)),50);
    title(ti{i})
    grid on
    if i == 1, axis tight, v = axis; else axis(v), end
end

% 8.4.6
% Watermark
A = imread('BabyC.jpg');
B = A*0.3;
figure, imshow(255*0.7+B)


% 8.4.8
% Random panels
A = imread('BabyC.jpg');
B = [randomise_image_panel(A,'R'),randomise_image_panel(A,'G'),...
    randomise_image_panel(A,'B'),];
figure('Position',[100,100,800,220]),imshow(B)


% 8.4.10
% Inset smaller
A = rgb2gray(imread('BabyC.jpg')); % read image and convert to grey
for i = 1:6
    B = imresize(A,.5);
    A(1:size(B,1),1:size(B,2)) = B; % resize and inset
end
figure, imshow(A)


% 8.4.12
% Four colours
A = imread('BabyC.jpg');
s = size(A);
midR = round(s(1)/2); midC = round(s(2)/2);
A(1:midR,1:midC,1) = 255; % red top left
A(1:midR,midC+1:end,3) = 255; % blue top right
A(midR+1:end,1:midC,2) = 255; % green bottom left
A(midR+1:end,midC+1:end,[1 3]) = 255; % purple bottom right
figure, imshow(A)

% 8.4.14
% Green grid
A = imread('BabyC.jpg');
figure, imshow(A)
s = size(A);
lw = ceil(s(1)/200);
tenrows = round(linspace(1,s(1)-lw,11));
tencolumns = round(linspace(1,s(2)-lw,11));
B = A;
for i = 1:lw
    B(tenrows+i-1,:,:) = 0;
    B(tenrows+i-1,:,2) = 255;
    B(:,tencolumns+i-1,:) = 0;
    B(:,tencolumns+i-1,2) = 255;
end
figure, imshow(B)

% 8.4.16
% Shuffle the cat

A = imread('BabyC.jpg');
B = shuffle_image(A,4,5);
figure,imshow(A)
figure,imshow(B)


% 8.4.18
% Words
figure, hold on
words_around_shape({'Monday','Tuesday','Wednesday','Thursday',...
    'Friday','Saturday','Sunday'},0)


% 8.4.20
% 3 colours
A = double(imresize(imread('BabyC.jpg'),0.05));
r = A(:,:,1); g = A(:,:,2); b = A(:,:,3);
figure, hold on
set(gca,'FontName','Candara','FontSize',12)
grid on
scatter3(r(:),g(:),b(:),6,[r(:),g(:),b(:)]/255,'filled')
rotate3d
end

%--------------------------------------------------------------------------
function A = randomise_image_panel(A,s)
A(:,:,strfind('RGB',s)) = uint8(rand(size(A,1),size(A,2))*255);

end

function Im = shuffle_image(A,M,N)

if ndims(A)==2 %#ok<*ISMAT>
    A = cat(3,A,A,A); % make a grey image into rgb
end

Rows = floor(size(A,1)/M);
Columns = floor(size(A,2)/N);

Im = uint8(zeros(size(A)));

% Shuffle index
RP = reshape(randperm(M*N),M,N);
k = 1;
for i = 1:M
    for j = 1:N
        T = A((i-1)*Rows + 1 : i*Rows,...
            (j-1)*Columns + 1 : j*Columns,:); % take current block
        [new_r,new_c] = find(RP == k);
        Im((new_r-1)*Rows + 1 : new_r*Rows,...
            (new_c-1)*Columns + 1 : new_c*Columns,:) = T; % position
        % in the new row/column
        k = k + 1;
    end
end
end

function [p,q,r] = words_around_shape(C,mode)
N = numel(C);
if mode == 1
    C = sort(C);
end
hold on
axis([-2 2 -2 2])
axis square off
t = 2 * pi / N;
Co = [0; 1];
R = [cos(t) sin(t);-sin(t) cos(t)];
for i = 1:N
    r(i) = text(Co(1),Co(2),C{i},'Rotation',90 - t*(i-1)/pi*180);
    q(i) = plot([0 Co(1)],[0 Co(2)]);
    Co1 = R * Co;
    p(i) = plot([Co(1) Co1(1)],[Co(2) Co1(2)]);
    Co = Co1;
end
end