function Chapter7
close all % close all open figures
clc % clear the command window

% 7.4.2
% Email
s = ['Try to distinguish between e-mail addresses ending with "uk", '...
    'and those ending with something else. For example, check with ',...
    'n.o.body@fiction.co.uk and print out the result.'];
[first_part,second_part] = strtok(s,'@');
blanks_first_part = strfind(first_part,' ');
address1 = first_part(blanks_first_part(end)+1:end);
blanks_second_part = strfind(second_part,' ');
address2 = second_part(1:blanks_second_part(1)-1);
dots = strfind(address2,'.');
network_extension = address2(dots(end)+1:end);
address = [address1 address2];
if strcmp(network_extension,'uk')
    fprintf('UK address: %s\n',address)
else
    fprintf('non-UK address: %s\n',address)
end
% Change "n.o.body@fiction.co.uk" to "n.o.body@fiction.co.net" 
% and run this part of the code again

% 7.4.4
% Repeat
s = input('And you were saying?... ','s');
% Explain how this next line works ... :)
fprintf('Really, %s?\n',fliplr(strtok(fliplr(s))))


% 7.4.6
% Manipulating strings
% (a)
s = ['Once upon a time, a very long time ago now, about last Friday, ',...
'Winnie-the-Pooh lived in a forest all by himself under the ',...
'name of Sanders. "What does ''under the name'' mean?" asked ',... 
'Christopher Robin. "It means he had the name over the door in ',...
'gold letters, and lived under it."'];
disp(s)

% (b)
s = strrep(s,'Winnie-the-Pooh','Dawn French');
s = strrep(s,'Sanders','Stephen King');
s = strrep(s,'Christopher Robin','Bahama Mama');
disp(s)

% (c)
N1 = numel(s); 
N2 = sum(s~=' ');
fprintf('The string contains %i characters if counting the spaces\n',N1)
fprintf('and %i characters without the spaces.\n\n',N2)

% (d)
fprintf('The total number of words is %i.\n\n',N1-N2+1)


% 7.4.8
% Anagrams
C = {'Albania';'Andorra';'Austria';'Belarus';'Belgium';...
	'Bosnia and Herzegovina';'Bulgaria';'Croatia';'Cyprus';...
	'Czech Republic';'Denmark';'Estonia';'Finland';...
	'France';'Germany';'Greece';'Hungary';'Iceland';...
	'Ireland';'Italy';'Kosovo';'Latvia';'Liechtenstein';...
	'Lithuania';'Luxembourg';'Malta';'Moldova';'Monaco';...
	'Montenegro';'Netherlands';'Norway';'Poland';...
	'Portugal';'Republic of Macedonia';'Romania';...
	'Russia';'San Marino';'Serbia';'Slovakia';...
	'Slovenia';'Spain';'Sweden';'Switzerland';...
	'Turkey';'Ukraine';'United Kingdom';'Vatican City'};
S = upper(C{randi(numel(C))}); 
SS = S(randperm(length(S)));
InputString = sprintf(['Anagram of a European country --%s--',...
    '.\nYour guess? --> '],SS);
trial = 1;
while trial < 4
    UserC = input(InputString,'s');
    if strcmpi(UserC,S) % compare the string ignoring the case !!!
        fprintf('\n\nCongratulations! %s is correct!\n\n',S)
        break
    else
        trial = trial + 1;
        if trial == 4 % exit with no success
            disp(['GAME OVER! The country was ' S '.'])
        else
            fprintf('Not correct. Try again!\n')
        end
    end
end

% 7.4.8
% LaTeX matrix
disp(LaTeX_matrix(randi(10,3)))
end


function M = LaTeX_matrix(A)
% outputs a string array with the LaTeX syntax for matrix A
[m,n] = size(A);
s = '\\left[\\begin{array}\n{';
for i = 1:n, s = [s,'r']; end
s = [s,'}'];
for i = 1:m
    s1 = '';
    for j = 1:n
        s1 = [s1,'%d&'];
    end
    s1 = [s1(1:end-1), '\\\\\n'];
    s = [s, s1];
end
s = [s,'\\end{array}\\right]'];
A = A';
M = sprintf(s,A(:)');
end
