function Chapter6
close all % close all open figures
clc % clear the command window

% 6.4.2
% Vector
a = randn(30,1)*20 + 100;
disp(a)

% 6.4.4
% Misc
% (a)
k = rand * (12.6 - (-30.4)) - 30.4;
disp(k)

%(b)
A = randi([-40, 10],20);
A(A < k) = 0;
disp(A)

% (c)
mnzA = mean(A(A~=0));
disp(mnzA)

% (d)
rndA = A(randi(numel(A)));
disp(rndA)

% (e)
figure, imagesc(A), axis equal off
c = numel(unique(A)); % how many colours are needed
colormap(rand(c,3))

% (f)
r = randperm(size(A,1),4); % rows # to extract
B = A(r,:);
disp(B)

% (g)
propnzB = mean(B(:)~=0); % B is reshaped into a vector
disp(propnzB)

% (h)
disp('A random number between -30.4 and 12.6:'), disp(k)
disp('Mean of all non-zero elements of A:'), disp(mnzA)
disp('A random element of A:'), disp(rndA)
disp('Proportion of non-zero elements of B:'), disp(propnzB)


% 6.4.6
% Slot machine
outcomes = randi(6,10000,3);

wins = sum(outcomes(:,1) == outcomes(:,2) & ...
    outcomes(:,1) == outcomes(:,3));
disp(wins)

win_index = outcomes(:,1) == outcomes(:,2) & ...
    outcomes(:,1) == outcomes(:,3);
profit = 10000 - sum((win_index & outcomes(:,1) ~= 1) * 10) - ...
    sum((win_index & outcomes(:,1) == 1) * 50);
disp('Profit = '), disp(profit)


% 6.4.8
% Two disks
a = randn(5000,2);
ind = sqrt(a(:,1).^2+a(:,2).^2) < 0.7 | sqrt(a(:,1).^2+a(:,2).^2) > 1.5;
figure
plot(a(ind,1),a(ind,2),'g.')
axis equal, grid on

% 6.4.10
% Noisy signal #1
a = randn(1,1000).*(1:1000)*0.2; % random signal with increasing amplitude
y_offset = linspace(-400,200,1000); % increasing slope to add
s = a + y_offset; % the signal
[mins,ind_mins] = min(s);
[maxs,ind_maxs] = max(s);

figure, hold on, grid on
xlabel('time'), ylabel('amplitude')
plot([ind_mins, ind_maxs],[mins maxs],'ys','markersize',20,...
    'MarkerFaceColor','y')
% plot the min and the max first so that the signal plot goes over
plot(s,'k-')
plot([0 1000],[-400, 200],'r-','linewidth',1.5)
axis([0 1000 -600 800])


% 6.4.12
% Shaded regions
figure, grid on
fill([0 1 1 7 7 5 5 0],[1 1 8 8 9 9 5 5],[0.7 0.7 0.7])
x = rand(1000,1) * 7;
y = rand(1000,1) * 8 + 1;
index = (x > 0) & (x < 1) & (y > 1) & (y < 5) | ...
    (x > 1) & (x < 5) & (y > 5) & (y < 8) | ...
    (x > 5) & (x < 7) & (y > 8) & (y < 9);
hold on
plot(x(index),y(index),'k.')


% 6.4.14
% Two flowers
x = rand(2000,1) * 200 - 35;
y = rand(2000,1) * 100 - 20;
index1 = ((x - 30).^2 + (y - 40).^2 < 900) | ...
    ((x + 10).^2 + y.^2 < 1600);
index2 = ((x - 30).^2 + (y - 40).^2 < 64) | ...
    ((x + 10).^2 + y.^2 < 64);
figure, hold on
plot(x(~index1&~index2),y(~index1&~index2),'k.','markersize',15,...
    'color',[0.7 0.7 0.7])
plot(x(index1&~index2),y(index1&~index2),'rx','linewidth',2.5,...
    'markersize',10)
plot(x(index2),y(index2),'g+','linewidth',2.5,'markersize',10)
grid on, axis equal tight


% 6.4.16
% Singular matrices
% (a)
k = 10; % range of the matrix entry
T = 10000; % number of iterations
count = 0;
for i = 1:T
    m = randi([-k k],2);
    if det(m) == 0 % singularity check
        count = count + 1;
    end
end
fprintf(['Proportion of singular 2x2 integer-valued matrices in ',...
    '[-%i,%i]: %.4f\n'],k,k,count/T)

% (b)
c = zeros(1,50);
for k = 1:50
    count = 0;
    for j = 1:T
        m = randi([-k k],2);
        if det(m) == 0
            count = count + 1;
        end
    end
    c(k) = count;
end
figure
plot(c/T,'k-')
grid on
title('Proportion of singular 2x2 matrices with integer entries in [-k,k]')
xlabel('k')

% 6.4.18
% Poker hands
% (a)
% checking for three-of-a-kind
Values = {'1','2','3','4','5','6','7','8','9','10','J','Q','K'};
Suits = {'C','D','H','S'};
CardValue = zeros(1,5);
k = 0; % counter
while sum(CardValue==max(CardValue)) ~= 3 || numel(unique(CardValue)) ~=3
    k = k + 1;
    rp = randperm(52); % generate a new hand
    hand = rp(1:5);
    CardSuit = ceil(hand/13); % suit index
    CardValue = mod(hand,13) + 1;
end
for i = 1:5 % display the hand
    fprintf('%s%s ',Values{CardValue(i)},Suits{CardSuit(i)})
end
% print the number of trials
fprintf('\n\nNumber of trials before 3-of-a-kind = %d\n\n',k)


% (b)
% evaluating a hand
Values = {'A','2','3','4','5','6','7','8','9','10','J','Q','K'};
Suits = {'C','D','H','S'};
ph = {'high card','one pair','two pairs','three of a kind','straight',...
	'flush','full house','four of a kind','straight flush'};

% 	1 high card (none of the following)
% 	2 one pair
% 	3 two pair
% 	4 three of a kind
% 	5 straight (consecutive cards, mixed suits)
% 	6 flush (same suit, any value)
% 	7 full house (three of a kind and a pair)
% 	8 four of a kind
% 	9 straight flush (consecutive cards, same suit)

rp = randperm(52); % generate a new hand
hand = rp(1:5);
mask = zeros(13,4);
mask(hand) = 1;
ranking = zeros(9,1);
M = sum(mask,2); % how many of each value
mM = max(M); % largest number of equal values
if mM == 4
    ranking(8) = 1; % four
elseif (mM == 3)
    if isempty(find(M == 2)) %#ok<*EFIND>
        ranking(4) = 1; % three
    else
        ranking(7) = 1; % full house
    end
else
    if sum(M==2) == 2
        ranking(3) = 1; % two pair
    elseif sum(M==2) == 1
        ranking(2) = 1; % one pair
    end
end
if max(sum(mask)) == 5 % all of the same suit
    if max(find(M)) - min(find(M)) == 4 %#ok<MXFND> % consecutive
        ranking(9) = 1; % straight flush
    else
        ranking(6) = 1; % flush
    end
else
    if mM == 1 % all different and different suits
        if (max(find(M)) - min(find(M)) == 4) ... % consecutive
            || all(find(M') == [2 3 4 5 13]) % A 2 3 4 5
            ranking(9) = 1; % straight
        end
    end
end
% After all ranking 2:9 have been explored
if sum(ranking) == 0 %(none of the fancy hands)
    ranking(1) = 1; % high card hand
end
CardSuit = ceil(hand/13); % suit index
CardValue = mod(hand,13) + 1;
for i = 1:5 % display the hand
    fprintf('%s%s ',Values{CardValue(i)},Suits{CardSuit(i)})
end
fprintf('\n')
r = find(ranking);
disp(ph{r})

% 6.4.20
% Monte Carlo - circle rectangle
% (a)
cx = randi(10); cy = randi(10); r = randi(10);
bx = randi(10); by = randi(10); w = randi(10); h = randi(10);

% (b)
figure, hold on, axis equal, grid on
theta = linspace(0,2*pi,100);
plot(sin(theta)*r+cx,cos(theta)*r+cy,'b-','linewidth',2) % plot circle
Rx = [bx,bx+w,bx+w,bx,bx]; Ry = [by,by,by+h,by+h,by];
plot(Rx,Ry,'b-','linewidth',2) % plot rectangle

% (c)
% check whether to calculate or simulate
R = [Rx' Ry'];
T = [];
if all(sum((R - repmat([cx,cy],5,1)).^2,2) < r^2) % rectangle within
    ar = w * h; % area
elseif cx-r>=bx && cx+r<=bx+w && cy-r>=by && cy+r<=by+h % circle within
    ar = pi * r^2;
else
    T = 30000; % number of points for the Monte Carlo simulation
    % generate points within the tight square around the circle
    x = rand(T,1)*2*r+cx-r; y = rand(T,1)*2*r+cy-r;
    % find the number within the intersection
    in_rectangle = x>bx & x<bx+w & y>by & y<by+h;
    in_circle = (x-cx).^2 + (y-cy).^2 - r^2 < 0;
    ind = in_rectangle & in_circle;
    number_in = sum(ind);
    ar = number_in/T * (2*r)^2;
end

% (d)
figure, hold on, axis equal, grid on
if T % area has been estimated (not calculated)
   plot(x,y,'k.','markersize',2)
   plot(x(ind),y(ind),'r.','markersize',8)
end
title(['Area = ',num2str(ar)])
plot(sin(theta)*r+cx,cos(theta)*r+cy,'b-','linewidth',2) % plot circle
plot(Rx,Ry,'b-','linewidth',2) % plot rectangle

% 6.4.22
% Evolutionary
% The chromosome is a binary vector of length 25x25 matrix = 625.
% The fitness function = number of 1s in the chromosome; large is better.
% Start with a random population with 10 chromosomes.
% Use only mutation; set the mutation probability to 0.15.
% Run your algorithm for 20 generations.
gs = 25; % grid size
ps = 10; % population size
P = rand(ps,gs^2) > 0.5; % population
Pm = 0.15; % mutation probability
F = sum(P,2); % evaluation of P
figure
for i = 1:400 % up to 20 generations
    O = P; % offspring
    M = rand(size(O)) < Pm; % mutation mask
    O(M) = 1 - O(M); % mutate offspring
    FO = sum(O,2); % evaluation of offspring
    FA = [F;FO]; % concatenate the fitness
    A = [P;O]; % all chromosomes available
    [~,ind] = sort(FA,'descend');
    P = A(ind(1:ps),:); % selected population
    F = FA(ind(1:ps)); % corresponding fitness

    % At each new generation, plot the best chromosome in the current
    % population using the `spy' command. Format the chromosome as a
    % 25x25 matrix. An ideal chromosome will have all spaces filled.
    % The worst chromosome will be an empty square in the figure.
    spy(reshape(P(1,:),gs,gs))
    title(['Best chromosome at iteration ' num2str(i)])
    drawnow
end
% At the end, print out the fitness value of the best chromosome,
% and show the chromosome as explained above.
figure, hold on
spy(reshape(P(1,:),gs,gs))
title(['Best chromosome''s fitness value: ' num2str(F(1))])


% 6.4.24
% Virtual bugs
figure
P = rand(25) > 0.4;
directions = [1 0;0 1;-1 0;0 -1]; % for possible moves
k = 0; % counter of the steps
while sum(sum(P)) > 0 % bugs left
    W = zeros(25); % new canvas
    for i = 1:25
        for j = 1:25
            if P(i,j) % bug
                move = ceil(rand*4);
                if (i + directions(move,1) > 0) &&...
                        (i + directions(move,1) < 26) ...
                        && (j + directions(move,2) > 0) &&...
                        (j + directions(move,2) < 26)
                    % inside the grid
                    W(i + directions(move,1),j + directions(move,2)) = ...
                        W(i + directions(move,1),j + ...
                        directions(move,2)) + 1;
                end
            end
        end
    end
    W(W>1) = 0; % kill the multiple bugs in a cell
    P = W;
    spy(P)
    k = k + 1; % steps
    pause(0.05)
end
close
fprintf('Number of steps = %d\n',k)


% 6.4.26
% Greedy tsp
ci = rand(10,2); % cities' positions
[g,dg] = greedy_tsp(ci);
figure, hold on
plot([ci(g,1);ci(g(1),1)],[ci(g,2);ci(g(1),2)],...
    'go-','linewidth',2,'markersize',12);
plot([ci(g,1);ci(g(1),1)],[ci(g,2);ci(g(1),2)],...
    'ro','linewidth',2,'markersize',8);
axis square, grid on
title(['GREEDY Minimum d = ',num2str(dg)])
end

%--------------------------------------------------------------------------
function [p,d] = greedy_tsp(cities)

n = size(cities,1); di = zeros(n);
for i = 1:n-1
    for j = i+1:n
        di(i,j) = sum((cities(i,:) -  cities(j,:)).^2);
        di(j,i) = di(i,j);
    end
end
di = sqrt(di);

d = 0;
p = 1; % cities visited
cn = 2:n; % cities not visited yet
for i = 1:n-1
    [sd,next_city] = min(di(cn,p(end)));
    d = d + sd; % add the smallest distance sd
    p = [p, cn(next_city)]; % add the new city to the list
    cn(next_city) = []; % remove the new city from non-visited
end
d = d + di(p(end),1);
end
