function Chapter5
close all % close all open figures
clc % clear the command window

% 5.3.2
% Plotting circles
figure, hold on, axis equal off
for i = 1:30
    plot_circle(rand,rand,rand*0.2,rand(1,3))
end

% 5.3.4
% Random art square
figure, hold on
for i = 1:20
    ver = randi([3,6]);
    fill(rand(ver,1),rand(ver,1),rand(1,3))
end
axis([0.2 0.8 0.2 0.8])
axis square off

% 5.3.6
% Nested squares
figure, hold on, axis equal
nested_squares(10)

% 5.3.8
% Four polygons
figure, hold on
k = 10; x = [0; rand(k-1,1)]; y = [0; rand(k-1,1)];
% vertex (0,0) is needed for touching in the centre
co = rand(1,3); % fill colour
fill(x,y,co); fill(-x,y,co);fill(x,-y,co);fill(-x,-y,co);
axis equal off

% 5.3.10
% Grid of shapes
% (a)
figure, hold on
ind = 1;
h = zeros(1,25);
for i = 1:5
    for j = 1:5
        h(ind) = fill(rand(1,6)+0.9*i,rand(1,6)+0.9*j,rand(1,3));
        ind = ind + 1;
    end
end
axis equal off

% (b)
figure
subplot(1,2,1), hold on
ind = 1; 
X = rand(25,6); Y = rand(25,6); C = rand(25,3); % the forms
for i = 1:5
    for j = 1:5
        fill(X(ind,:)+0.9*i,Y(ind,:)+0.9*j,C(ind,:));
        ind = ind + 1;
    end
end
axis equal off
title('Original')

subplot(1,2,2), hold on
% permute the figures
rp = randperm(25); X = X(rp,:); Y = Y(rp,:); C = C(rp,:);
ind = 1;
for i = 1:5
    for j = 1:5
        fill(X(ind,:)+0.9*i,Y(ind,:)+0.9*j,C(ind,:));
    ind = ind + 1;
    end
end
axis equal off
title('Shuffled')


% 5.3.12
% Diamonds in a loop
% (a)
figure, hold on
T = 5;
for i = 1:T
    plot([0 i 0 -i 0],[-i 0 i 0 -i],'k-','color',[i 0 0]/T,'linewidth',5)
end
axis equal off

% (b)
figure, hold on
T = 100;
for i = 1:T
    if i <= T/2
        plot([0 i 0 -i 0],[-i 0 i 0 -i],'k-',...
            'color',2*[0 i 0]/T,'linewidth',5)
    else
        plot([0 i 0 -i 0],[-i 0 i 0 -i],'k-',...
            'color',[0 0 i-T/2]/(T/2),'linewidth',5)
    end
end
axis equal off


% 5.3.14
% Balloons
% (a) Function is further down
figure, hold on, axis equal off
draw_balloon(0,0,10,'r',5)

% (b)
figure, hold on, axis equal off
for i = 1:20
    draw_balloon(rand, rand, rand*0.1+0.05, rand(1,3), rand*0.3+0.3)
end

% (c)
figure, hold on, axis equal off
for i = 1:20
    ra = rand*0.1+0.05; % radius
    draw_balloon(rand, 1-ra, ra, rand(1,3), rand*0.3+0.3)
end
v = axis;
fill([v(1) v(2) v(2) v(1)],[v(4) v(4) v(4)+0.1 v(4)+0.1],[0.7 0.7 0.7])



end
%--------------------------------------------------------------------------
function plot_circle(x,y,r,c)
theta = linspace(0,2*pi,100);
fill(x+sin(theta)*r,y+cos(theta)*r,c)
end

function nested_squares(k)
hold on
for i = 1:k
    w = k-i+1;
    fill([w,w,-w,-w],[-w,w,w,-w],rand(1,3))
end
axis equal off
end

function draw_balloon(x,y,r,c,l)
t = linspace(0,2*pi,100);
fill(sin(t)*r + x, cos(t)*r + y, c) % draw balloon

b = rand*2*pi; % random phase of the string
zy = linspace(0,l,50);
zx = linspace(0,3*rand*pi+2*pi,50);
plot(x+sin(zx+b)*0.15*r-sin(b)*0.15*r,...
y-r-zy,'k-') % draw string, amplitude 0.15*r

p = 0.08*r; % the blower triangle offset
fill([x-p x+p x],[y-r-p y-r-p y-r],c) % draw blower
plot(x,y-r,'k.')

% draw light reflection
l1 = 80; l2 = 92;
fill([sin(t(l1:l2))*0.8*r + x, sin(t(l2:-1:l1))*0.68*r + x], ...
[cos(t(l1:l2))*0.8*r + y,cos(t(l2:-1:l1))*0.6*r + y],...
'w','EdgeColor','none')
end
