function Chapter4
close all % close all open figures
clc % clear the command window

% 4.2.2
% euclidean distance
P = [3 4;1 2]; Q = [-2 5;3 -1; 7 4];
disp(euclidean_distance_arrays2(P,Q))
pdist2(P,Q)

% 4.2.4
% point in a square
point_in_a_square(0.3,0.8,0,0,1)
point_in_a_square(0.3,1.8,0,0,1)
point_in_a_square(1,0.8,0,0,1)

% 4.2.6
% Fibonacci recursive
for i = 1:10
    disp(fibo_recursive(i))
end

% 4.2.8
% Bubble sort
a = randi(500,1,10) - 250;
b = bubble_sort(a);
disp(a)
disp(b)

end

% 4.2.2
% euclidean distance
function D = euclidean_distance_arrays(A,B)
for i = 1:size(A,1)
    x = A(i,:); % ith row of A
    for j = 1:size(B,1)
        y = B(j,:); % jth row of B
        D(i,j) = sqrt(sum((x-y).^2));
    end
end
end

function D = euclidean_distance_arrays2(A,B)
N = size(A,1); M = size(B,1);
AA = repmat(A,M,1); BB = repmat(B',1,N)';
D = reshape(sqrt(sum((AA-BB).^2,2)),M,N);
end

% 4.2.4
% point in a square
function is_in = point_in_a_square(x,y,p,q,s)
is_in = x >= p & x <= p + s & y >= q & y <= q + s;
end


% 4.2.6
% fibonacci
function o = fibo_recursive(k)
if k < 2
    o = k;
else
    o = fibo_recursive(k-1) + fibo_recursive(k-2);
end
end

% 4.6.8
% bubble sort 
function A = bubble_sort(A)
SWAP = true;
i = 1;
N = numel(A);
while SWAP
    SWAP = false;
    for j = 1 : N - i
        if A(j) > A(j+1)
            A([j,j+1]) = A([j+1,j]);
            SWAP = true;
        end
    end
    i = i + 1;
end
end


