clear % clear memory
close all % close all open figures
clc % clear the command window

% 3.6.2
disp(37:37:1000) % first way
find(~mod(1:1000,37)) % second way

% 3.6.4
z = rgb2gray(imread('peppers.png')); figure, imshow(z)
z(z<=100) = 0; % black
z(z>100&z<200) = 150; % light grey
z(z>=200) = 255; % white
figure, imshow(z)

% 3.6.6
figure, hold on, grid on, axis square
x = rand(10000,1)*10; y = rand(10000,1)*10;
% ind = x>3 & x<8 & y<4 & y>1;
% ind = (x-3).^2 + (y-8).^2 < 4;
% ind = x < y;
% ind = 2*x + 3*y  -18< 0;
% ind = xor(((x-6).^2 + (y-6).^2 < 4) , x > y);
% ind = (8*x-3*y-13 > 0) & (-8*x-3*y+67>0) & (y > 1);
% ind = xor(((8*x-3*y-13 > 0) &(-8*x-3*y+67>0)&(y > 1)),...
%     ((x-5).^2 + (y-4).^2 < 1));
% ind = xor(((8*x-3*y-13 > 0) &(-8*x-3*y+67>0)&(y > 1)),...
%     ((x-5).^2 + (y-4).^2 < 1));
ind = ~((x>4.5&x<5.5&y>1&y<9)|(x>1&x<9&y>4.5&y<5.5));

plot(x(ind),y(ind),'k.','markersize',10)
plot(x(~ind),y(~ind),'g.','markersize',10)

% 3.6.8
% guess my number
NumberToGuess = randi(10);
UserGuess = input('Please enter your guess -> ');
if UserGuess == NumberToGuess
    disp('Congratulations! You won!')
else
    disp('You lost! Better luck next time! The number was')
    disp(NumberToGuess)
end

% 3.6.10
% (a)
m = 20; n = 30;
A = rand(m,n) < 0.1; % sparse
% A = rand(m,n) < 0.5; % medium
% A = rand(m,n) < 0.7; % dense
B = zeros(m+2,n+2); % padding
B(2:end-1,2:end-1) = A; % inset A
S = 0; % sum of neighbours
for i = 2:m+1
    for j = 2:n+1
        if B(i,j) % bug
            S = S + sum(sum(B(i-1:i+1,j-1:j+1))) - 1; % only neighbours
        end
    end
end
disp('Averge number of neighbours per bug:')
disp(S/sum(B(:)))

% (b)
A = rand(m,n) < 0.7;
B = zeros(m+2,n+2); % padding
G = B; % the new generation
B(2:end-1,2:end-1) = A; % inset A
for i = 2:m+1
    for j = 2:n+1
        on = sum(sum(B(i-1:i+1,j-1:j+1))) - B(i,j); % only neighbours
        if (B(i,j) && (on == 2 || on == 3)) || (~B(i,j) && on == 3)
            G(i,j) = 1;
        end
    end
end
A = G(2:m-1,2:n-1); % the new generation

% (c)
A = rand(m,n) < 0.3;
B = zeros(m+2,n+2); % padding
B(2:end-1,2:end-1) = A; % inset A
figure('color','w'), spy(B), axis off
figure('color','w')
for k = 1:50
    G = zeros(m+2,n+2); % the clean grid for the new generation
    for i = 2:m+1
        for j = 2:n+1
            on = sum(sum(B(i-1:i+1,j-1:j+1))) - B(i,j); % only neighbours
            if (B(i,j) && (on == 2 || on == 3)) || (~B(i,j) && on == 3)
                G(i,j) = 1;
            end
        end
    end
    B = zeros(m+2,n+2); % padding
    B(2:end-1,2:end-1) = G(2:m+1,2:n+1); % new generation
    spy(B), axis off
    pause(0.2)
end

% (d)
m = 25; n = 40;
A = zeros(m,n);
gb = [6,2;6,3;7,2;7,3;6,12;7,12;8,12;5,13;9,13;4,14;10,14;4,15;10,15;...
    7,16;5,17;9,17;6,18;7,18;8,18;7,19;4,22;5,22;6,22;4,23;5,23;6,23;...
    3,24;7,24;2,26;3,26;7,26;8,26;4,36;5,36;4,37;5,37]; % the gun bugs
A(sub2ind([m,n],gb(:,1),gb(:,2))) = 1; % position the gun bugs
B = zeros(m+2,n+2); % padding
B(2:end-1,2:end-1) = A; % inset A
figure('color','w'), spy(B), axis off
figure('color','w')
for k = 1:250
    G = zeros(m+2,n+2); % the clean grid for the new generation
    for i = 2:m+1
        for j = 2:n+1
            on = sum(sum(B(i-1:i+1,j-1:j+1))) - B(i,j); % only neighbours
            if (B(i,j) && (on == 2 || on == 3)) || (~B(i,j) && on == 3)
                G(i,j) = 1;
            end
        end
    end
    B = zeros(m+2,n+2); % padding
    B(2:end-1,2:end-1) = G(2:m+1,2:n+1); % new generation
    spy(B), axis off
    pause(0.02)
end