function Chapter11
close all % close all open figures
clc % clear the command window


% 11.2.2
% Piano keyboard
% Function is further down
piano_keyboard

% 11.2.4
% Music scales
noteFrequency = [261.63 293.66 329.63 349.23 392.00 440.00 493.88 523.25];
fs = 8000; % sampling frequency
% (a)
y = [];
T = 1; % time in seconds
t = 0:1/fs:T;
A = (T - t) / T; % fading amplitude
for i = 1:8
    no = noteFrequency(i);
    s = A .* (sin(2*pi*t*no) + 0.2*(sin(pi*t*no) + sin(4*pi*t*no)));
    y = [y, 0 s];
end
sound(y,fs)
pause

% (b)
y = [];
T = 1;
t = 0:1/fs:T;
A = (T - t) / T;
for i = 1:8
    no = noteFrequency(i);
    noback = noteFrequency(9-i);
    s1 = A .* (sin(2*pi*t*no) + 0.2*(sin(pi*t*no) + sin(4*pi*t*no)));
    s2 = A .* (sin(4*pi*t*noback) + 0.2*(sin(2*pi*t*noback) + ...
        sin(8*pi*t*noback)));
    y = [y, 0 0.8 * s1 + 0.2 * s2];
end
sound(y,fs)
%wavwrite(y,fs,'scales_harmony.wav')
yb = y; % save the signal for the plot in 2(d)
pause

% (c)
y = [];
T = linspace(1,0.1,8);
fs = 8000;
for i = 1:8
    t = 0:1/fs:T(i);
    no = noteFrequency(i);
    noback = noteFrequency(9-i);
    A = (T(i) - t) / T(i); % amplitude is specific for duration T(i)
    no = noteFrequency(i);
    noback = noteFrequency(9-i);
    s1 = A .* (sin(2*pi*t*no) + 0.2*(sin(pi*t*no) + sin(4*pi*t*no)));
    s2 = A .* (sin(4*pi*t*noback) + 0.2*(sin(2*pi*t*noback) + ...
        sin(8*pi*t*noback)));
    y = [y, 0 0.8 * s1 + 0.2 * s2];
end
sound(y,fs)

% (d)
% fs per second, fs/1000 per milisecond, round(30*fs/1000) per 30 ms
N = round(30*fs/1000); % number of samples corresponding to 30 ms
X = linspace(0,30,N); % prepare x-axis
figure, plot(X,yb(1:N),'k-')
set(gca,'FontName','Candara','FontSize',12)
title('The first 30 ms of the harmony scale signal')
xlabel('time [ms]')
ylabel('sound signal')


% 11.2.6
% What Does Music Look Like?
load handel
see_music(y)
end
%--------------------------------------------------------------------------
function piano_keyboard

figure('Units','Normalized','Position',[1 1 4 6]*.1)
f = 440*2.^((-9:3)/12); % note frequencies

q = [1:2:5 6:2:12 13];
for i = 1:8 % white keys
    uicontrol('Un','N','Pos',[i,1,1,8]/10,'Ba','w',...
        'Callback',{@n,f(q(i))});
end

r = [2 4 0 7:2:11];
for i = [1 2 4 5 6] % black keys
    uicontrol('Un','N','Pos',[.6+i,3.4,.7,5.6]/10,'Ba','k',...
        'Callback',{@n,(f(r(i)))});
end
    function n(~,~,F)
        fs = 6^5;
        T = 1;
        t = 0:1/fs:T;
        sound((T-t)/T.* sin(2*pi*t*F),fs)
    end
end

function see_music(y)
N = numel(y);
T = 2000;
hos = floor(N/T); % split into T pieces
ints = floor(N/hos);
y = y(1:ints*hos); % truncate to a multiple of hos
r = reshape(y,hos,[]); % arrange consecutive intervals of length hos
pf = mean(abs(diff(r>0))); % find a proxy for the frequencies
Q = linspace(0,2*pi,T);
figure, hold on
for i = 1:min(ints,T)
    plot([0 pf(i)*sin(Q(i))],[0 pf(i)*cos(Q(i))],'k-','color',[0 i/ints 0])
end
axis equal off
end