clear % clear memory
close all % close all open figures
clc % clear the command window

% 10.3.2
% Coloured alphabet
figure('Units','Normalized','Position',[0.1 0.4 0.8 0.2])
le = 'A':'Z';
for i = 1:26
    b(i) = uicontrol('Units','Normalized','Position',...
        [(i-1)*(1/26)+0.0003,0.1,(1/26)-0.001,0.8],...
        'BackgroundColor',rand(1,3),'String',le(i),...
        'FontName','candara','FontSize',20);
    set(b,'Callback','set(gco,''BackgroundColor'',''k'')')
end
rp = randperm(26);
set(b(rp(1)),'Callback','delete(b),set(gcf,''color'',''k'')')
set(b(rp(2)),'Callback','delete(b),set(gcf,''color'',''k'')')


% 10.3.4
% Disappearing green button
figure('color','k','Units','Normalized','Position',[0.1 0.1 0.8 0.8])
a = 0.2; b = 0.1;
stepsx = linspace(a,0.001,100);
stepsy = linspace(b,0.001,100);
waitforbuttonpress
p  = get(gcf,'CurrentPoint');
uicontrol('Units','Normalized','Position',[p(1)-a,p(2)-b,2*a,2*b],...
    'BackgroundColor','g',...
    'String','Press to disappear','Fontname','Candara','FontSize',16,...
    'Callback',['set(gco,''String'',''''),for i = 1:100,',...
    'set(gco,''Position'',[p(1)-stepsx(i),p(2)-stepsy(i),',...
    'stepsx(i)*2,stepsy(i)*2]),pause(0.01),end,',...
    'delete(gco),set(gcf,''color'',''g'')'])
    
    
% 10.3.6
% Scrabble helper
% function scrabble_helper
figure
% letter tile frequencies (100 tiles in total)
ltf = [9 2 2 4 12 2 3 2 9 1 1 4 2 6 8 2 1 6 4 6 4 2 2 1 2 1 2];
let = ['A':'Z',' '];
to_show = ''; % the sequence of 100 tile
for i = 1:27
    to_show = [to_show, repmat(let(i),1,ltf(i))];
end
k = 1; % index in array to_show
for j = 10:-1:1
    for i = 1:10
        uicontrol('Un','N','Pos',[i-1,j-1,1,1]/10,'Str',to_show(k),...
            'FontName','Candara','FontSize',18,...
            'ForegroundColor',[0.8 0.4 0.4],'Callback',...
            'co = get(gco,''Ba'');set(gco,''Ba'',1 - co)');
        k = k + 1;
    end
end


% 10.3.8
% Four coloured squares
figure, hold on, axis equal off
x = [0 7 7 0]'; y = [0 0 7 7]';
sq = fill([x -x -x x],[y y -y -y],'w');
str = text(-3,-8,'');
q ='3412';f='1432';
for i = 1:4
uicontrol('str',['Square ' f(i)],'Un','N','Pos',[x(i) y(i) 1 1]/8,...
        'Ca',['c=rand(1,3);set(sq,''Facec'',''w''),set(sq(',q(i),'),',...
        '''Facec'',c),set(str,''St'',num2str(c))']); 
end

% 10.3.10
% Remove-the-triangle game
f = figure; hold on, axis([0 1 0 1]), axis square off
triangle_count = 0;
h = zeros(1,20); % array with handles
while triangle_count < 20
    S = 0;
    while S < 0.05
        X = rand(1,3); % x-coordinates of the vertices
        Y = rand(1,3); % y-coordinates of the vertices
        S = abs((X(2)*Y(1)-X(1)*Y(2))+(X(3)*Y(2)-X(2)*Y(3))+ ...
            (X(1)*Y(3)-X(3)*Y(1)))/2; % area
    end
    triangle_count = triangle_count + 1;
    h(triangle_count) = fill(X,Y,rand(1,3));
end

% Create a sound effect
fs = 8000; % the sampling frequency
T = 0.1;% length of the note in seconds
t = 0:1/fs:T;
C = 800; % frequency
y = [sin(C*2*pi*t) zeros(1,20) sin(C*2*pi*t)]; % the signal

j = 20;
while j > 0
    k = waitforbuttonpress;
    hh = gco;
    if k == 0
        if j == 20
            tic
        end
        if hh == h(j)
            set(hh,'visible','off')
            j = j - 1;
        else
            sound(y,fs)
        end
    end
end
t = toc;
fill([0 1 1 0],[0 0 1 1],[0.8 0.8 0.8],'edgecolor','none')
tt = text(0.25,0.5,sprintf('Your time is %.2f s.\n',t));
set(tt,'FontName','Candara','FontSize',18)


% 10.3.12
% Colour boxes game
figure
k = 1;
for j = 1:4
    for i = 1:5
        h(k) = uicontrol('units','normalized','backgroundcolor','k',...
            'position',[0.1+(i-1)*0.16, 0.18+(4-j)*0.16, 0.16, 0.16]);
        k = k + 1;
    end
end
order_of_squares = randperm(20);
tic
for i = 1:20
    set(h(order_of_squares(i)),'Backgroundcolor',rand(1,3))
    k = 1;
    while (k ~=0)||(gco ~= h(order_of_squares(i)))
        k = waitforbuttonpress;
    end
    delete(h(order_of_squares(i)))
end
st = sprintf('Done in %.2f s',toc);
end_text = uicontrol('style','text','units','normalized',...
    'position',[0.2, 0.5, 0.55, 0.1],'backgroundcolor',get(gcf,'color'),...
    'FontName','Trebuchet MS','FontSize',16,'string',st);


% 10.3.14
% How fast can you find the numbers?
k = 1; % button counter
rp = randperm(100); % number distribution
tic % start the clock
topress = 1; % next number to press
fs = 8000; cli = sin(2*pi*800*(0:1/fs:0.1)); % click sound
t = (0:1/fs:0.05)*15000; % prepare the frequencies for sound "wrong"
fi = 20; % <--- final number to count to
figure
for i = 1:10 % rows of buttons
    for j = 1:10 % columns of buttons
        uicontrol('Un','N','Po',[(i-1)/10,(j-1)/10,0.1,0.1],...
            'Ba',rand(1,3)*0.4,'Str',num2str(rp(k)),...
            'For','w','FontN','Candara','FontS',16,...
            'Callback',['nu = str2num(get(gco,''Str''));',...
            'if nu == topress, topress = topress + 1;',...
            'set(gco,''Enable'',''off'',''Ba'',''w''),',...
            'sound([cli,cli],fs);else,',...
            'w = [sin((0.5+rand*0.5)*t),sin((0.5+rand*0.5)*t)];',...
            'sound(w,fs),end, if topress == fi+1, clf,',...
            'annotation(''textbox'',''position'',[0.2 0.2 0.6 0.6],',...
            '''Horiz'', ''center'',''Vert'', ''middle'',''String'',',...
            '[''Your time: '' num2str(toc) '' s''],''FontN'',',...
            '''Segoe Print'',''FontS'',14,''EdgeColor'',''none'');end']);
        k = k + 1;
    end
end


% 10.3.16
% Mirror image
[filename, pathname] = uigetfile('*.jpg');
a = imread([pathname filename]);
flippedIm(:,:,1) = fliplr(a(:,:,1));
flippedIm(:,:,2) = fliplr(a(:,:,2));
flippedIm(:,:,3) = fliplr(a(:,:,3));
gr = [0.8 0.8 0.8]; % grey colour for the button background
f = figure;
axes('position',[0.05 0.05 0.9 0.75])
axis off
imshow(a)
b(1) = uicontrol('Parent',f,'Style','push',...
    'units','normalized','position',[0.2 0.9 0.6 0.08], ...
    'string','Original image','BackgroundColor','g',...
    'Callback',['imshow(a),set(b(1),''BackgroundColor'',''g''),',...
    'set(b(2),''BackgroundColor'',gr)']);
b(2) = uicontrol('Parent',f,'Style','push',...
    'units','normalized','position',[0.2 0.82 0.6 0.08], ...
    'string','Flipped image','BackgroundColor',gr,...
    'Callback',['imshow(flippedIm),set(b(1),''BackgroundColor'',gr),',...
    'set(b(2),''BackgroundColor'',''g'')']);
set(b,'FontName','Candara','FontSize',14)


% 10.3.18
% Moving car
figure('Color','w')
A = imread('YellowCar.jpg');
h = axes('position',[0.02,0.5,0.3,0.1]);
imshow(A)
b(1) = uicontrol('Un','N','Pos',[0.05,0.05,0.25 0.1],'Str','Backward',...
    'Callback',['p = get(h,''Pos'');,',...
    'set(h,''Pos'',[max(p(1)-0.01,0),p(2),p(3),p(4)])']);
b(2) = uicontrol('Un','N','Pos',[0.7,0.05,0.25 0.1],...
    'Str','Forward',...
    'Callback',['p = get(h,''Position'');,',...
    'set(h,''Position'',[min(1-p(3),p(1)+0.01),p(2),p(3),p(4)])']);
b(3) = uicontrol('Un','N','Position',[0.4,0.05,0.2 0.1],...
    'Str','Move','Callback','move_the_car');
set(b,'FontN','Tempus Sans ITC','FontS',18,'Ba',[0 0 0],'For',[1 1 1])

% File "move_the_car.m" is needed for Solution 10.3.18
% p = get(h,'Position');
% while p(1)+p(3) < 1
%    set(h,'Position',[p(1)+0.005,p(2),p(3),p(4)])
%    p = get(h,'Position');
%    pause(0.005);
% end
% CarFlip(:,:,1) = fliplr(A(:,:,1)); 
% CarFlip(:,:,2) = fliplr(A(:,:,2)); 
% CarFlip(:,:,3) = fliplr(A(:,:,3));
% imshow(CarFlip)
% p = get(h,'Position');
% while p(1)-0.01 > 0
%    set(h,'Position',[p(1)-0.005,p(2),p(3),p(4)])
%    p = get(h,'Position');
%    pause(0.005);
% end
% imshow(A)

