% Kuncheva L.I. and I. Zliobaite, On the Window Size for Classification 
% in Changing Environments, Intelligent Data Analysis, 13 (6), 2009, 
% 861-872.
% http://pages.bangor.ac.uk/~mas00a/papers/lkizida09.pdf

clear, clc, close all


%% Optimal N
clear all

N = 2:2:50;% sample size (must be an even number)
delta = 1; % distance between the means
theta = 1; % offset at the change point
T1 = 40; % number of observations before the change
T = 200; % total transition window
n = 1; % dimensionality of the feature space
Tmax = 300; % max iterations

fC = Fukunaga89(delta,1);
TrueError = normcdf(-delta/2); 
e2R1 = 1/2*(normcdf(-delta/2 - delta*theta) + ...
    normcdf(-delta/2 + delta*theta));

Nopt = 2*sqrt(T*fC/(e2R1 - TrueError));

% Find optimal N through simulation

for j = 1:length(N);
    % Addition to the error due to the sample size:
    %--------------
    F89(j) = 2*fC/N(j);
    %--------------
    for K = 1:T1 
        Sample1 = randn(N(j)/2,1); m1 = mean(Sample1);
        Sample2 = randn(N(j)/2,1) + delta; m2 = mean(Sample2);
        GE1(K) = normcdf(-(m2-m1)/2);
    end
    for K = 1: T - N(j) - T1 
        Sample1 = randn(N(j)/2,1); m1 = mean(Sample1);
        Sample2 = randn(N(j)/2,1) + delta; m2 = mean(Sample2);
        GE2(K) = normcdf(-(m2-m1)/2);
    end


    % Theoretical error
    for k = 1:N(j) % proportion from Source 1 (alpha = k/N)
        TE(k) = 1/2*(normcdf(-delta/2 - theta*delta*(1 - k/N(j))) + ...
            normcdf(-delta/2 + theta*delta*(1 - k/N(j))));
        TE(k) = TE(k) + F89(j);
        for K = 1:Tmax % trials at sample size N(j)
            Sample1 = randn(ceil(k/N(j)/2),1) - theta*delta;
            Sample2 = randn(ceil(k/N(j)/2),1) - theta*delta + delta; 
            Sample3 = randn(ceil((1 - k/N(j))/2),1) + delta;
            Sample4 = randn(ceil((1 - k/N(j))/2),1); 
            m1 = mean([Sample1;Sample4]);
            m2 = mean([Sample2;Sample3]);
            bnew = (m1 + m2)/2;
            GuessedError(K) = 1/2*(normcdf(bnew  - delta*(1 - theta)) + ...
            normcdf(-bnew  - delta*theta));
        end
        GE(k) = mean(GuessedError);
    end
    tv = TrueError + F89(j);
    WindowForError = [tv*ones(1,T1), TE, tv*ones(1,T - N(j) - T1)];
    WindowForGError = [GE1, GE, GE2];
    ThE(j) = mean(WindowForError);
    GuE(j) = mean(WindowForGError);
    
    %e(j) = TrueError + 1/N(j)*fC + N(j)*(e2R1 - TrueError)/(2*T);
    e(j) = TrueError + 2/N(j)*fC + N(j)*(e2R1 - TrueError)/(2*T);
    clear TE GE GE1 GE2
end
        
figure
hold on
plot(N,ThE,'rx-','linewidth',1.5,'markersize',12)
plot(N,GuE,'b.-','linewidth',1.5,'markersize',20)
plot(N,e,'gv-','linewidth',1.5,'markersize',8)
v = axis;
plot([Nopt,Nopt],[v(3) v(4)],'k--','linewidth',1.5)
set(gca,'FontSize',16)
l = legend('Theoretical','Simulated','Approximated','Optimal window size');
set(l,'Box','on')
xlabel('Window size')
ylabel('Error')

[p1,q1] = min(ThE);
[p2,q2] = min(e);

fprintf('N_opt (calculated) = %.2f\n',Nopt)
fprintf('N_opt (theoretical) = %.2f\n',N(q1))
fprintf('N_opt (approximated) = %.2f\n',N(q2))

%grid on
