function z = generate_cone_torus(N)
% Input: N number of points
% Output:
% z - array of size N by 3.
% Columns 1 and 2 are the two features
% Column 3 is the label
% 1 -- cone; 2 -- torus; 3 -- normal

Count = 0;
z = [];

while Count < N,
    p = rand;
    x1 = 10*rand + 1;
    x2 = 10*rand + 1;
    if p < 0.25, %class cone
        t = sqrt((x1 - 4)^2 + (x2 - 2)^2);
        while t >= 2 || (rand > (3/8/pi*(2-t))),
            x1 = 10*rand+1;
            x2 = 10*rand+1;
            t = sqrt((x1-4)^2+(x2-2)^2);
        end
        z = [z;x1 x2 1];
        Count = Count+1;
    else
        if p < 0.5, %torus
            t = sqrt((x1-5)^2+(x2-2)^2);
            while (3>t)||(t>=4)||(x2<=2)||(rand>(2/7/pi))
                x1 = 10*rand+1;
                x2 = 10*rand+1;
                t = sqrt((x1-5)^2+(x2-2)^2);
            end
            z = [z;x1 x2 2];
            Count = Count+1;
        else %normal
            d = 1/sqrt(8*pi)*exp(-1/8*((x1-7)^2+(x2-6)^2));
            while rand > d,
                x1 = 10*rand + 1;
                x2 = 10*rand + 1;
                d = 1/sqrt(8*pi)*exp(-1/8*((x1-7)^2+(x2-6)^2));
            end
            z = [z;x1 x2 3];
            Count = Count + 1;
        end
    end
end
