function [x,labx] = p_gaussians_3class_changing_variance(k,n)
%P_GAUSSIANS_3CLASS_CHANGING_VARIANCE samples from 3 Gaussian classes
%with static means and changing variances
%
%   [x,labx] = P_GAUSSIANS_3CLASS_CHANGING_VARIANCE(k,n)
%
%   The data is a Gaussian mixture with 3 components, each corresponding
%   to a class. The means of the first two components of x are at [-2 -1],
%   [2 -1] and [0 2], respectively. The remaining n-2 components have
%   means 0. (If n is not specified, or its value is 0 or 1, the default
%   value n = 2 is used.) The covariance matrices are diagonal. The
%   variances of the first two features are varied but are kept equal
%   within each cluster. The classes are equiprobable.
%
%   Input
%   k:     Concepts 1 to 5 correspond to the following sets of standard
%          deviations for the three classes:
%               s1     s2    s3
%          1:  1.4    1.1    0.1
%          2:  0.6    0.4    1.7
%          3:  1.3    1.3    0.9
%          4:  0.3    0.3    0.1
%          5:  1.6    0.3    1.4

%   Output
%   x:     a data point described by two features
%   labx:  a class label (1, 2 or 3)

%--------------------------------------------------------------------------
%   Last modified: L Kuncheva 23/01/16

S =[
    1.4    1.1    0.1
    0.6    0.4    1.7
    1.3    1.3    0.9
    0.3    0.3    0.1
    1.6    0.3    1.4
    ];

if nargin == 1, n = 2; end

mo = [-2, -1;2, -1;0, 2]; % offset of the means
labx = randi(3); % class label of x

x = randn(1,n); % the data point before the offset
x(1:2) = x(1:2) * S(k,labx); % adjust the standard deviation
x(1:2) = x(1:2) + mo(labx,:); % adjust the mean of the first 2 features 
