clear, clc, close all
figure
T = 40; z = linspace(0,1,T);
for j = 1:4
    v = zeros(1,5);
    for t = 1:T
        clf
        % One data source gradually fades out, next one replaces it
        v(j) = 1-z(t);
        v(j+1) = z(t);
        V = repmat(v,500,1);
        [a,laba] = ...
            simulation_changing_environment...
            ('p_gaussians_3class_changing_variance',V);
        axis([-5 5 -5 5])
        grid off
        axis square
        set(gca,'Fontsize',14,'FontName','Candara','Box','on')
        hold on
        plot(a(laba==1,1),a(laba==1,2),'g.','markersize',15)
        plot(a(laba==2,1),a(laba==2,2),'k.','markersize',15)
        plot(a(laba==3,1),a(laba==3,2),'b.','markersize',15)
        pause(0.1)
    end
end

