clear, clc, close all
figure
T = 80; z = linspace(0,1,T);
for t = 1:T    
    clf    
    % One data source gradually fades out, while the other replaces it.    
    v = [z(t), 1-z(t)];    
    V = repmat(v,1000,1); % 1000 data points per time 
    [a,laba] = ...
        simulation_changing_environment('p_gaussian2d_4components',V);    
    axis([-15 15 -15 15])    
    grid off    
    axis square    
    set(gca,'Fontsize',14,'FontName','Candara','Box','on')    
    hold on    
    plot(a(laba==1,1),a(laba==1,2),'k.','markersize',40,'color','g')    
    plot(a(laba==2,1),a(laba==2,2),'k.','markersize',18)    
    drawnow
end
