function R = rho(x)
% RHO calculates the correlation diversity measure rho 
%    R = RHO(X) calculates the pairwise correlation diversity measure RHO 
%    for L classifier outputs. X is an array with N rows (data points) and 
%    L columns (classifiers in the ensemble). The entries of X are 0 for 
%    wrong classification and 1 for correct classification. R is a square 
%    matrix of size L-by-L. If X contains only two columns, then R is a 
%    single value.
% 
%   See also QCALC, DISAGREEMENT, DOUBLE_FAULT
%

%========================================================================
% (c) L. Kuncheva: Diversity Toolbox                                ^--^
% v.2.0 Nov 2011 -------------------------------------------------  \oo/
%

R = corrcoef(x);

if size(x,2) == 2 % only 2 classifiers
    R = R(1,2); % return one single value
end
