function Q = qcalc(x)
% QCALC calculates the Q diversity measure 
%    Q = QCALC(X) calculates the pairwise diversity measure based on Yule's 
%    Q-statistic for L classifier outputs. X is an array with N rows (data 
%    points) and L columns (classifiers in the ensemble). The entries of X 
%    are 0 for wrong classification and 1 for correct classification. Q is 
%    a square matrix of size L-by-L. If X contains only two columns, then Q
%    is a single value.
% 
%   See also RHO, DISAGREEMENT, DOUBLE_FAULT
%

%========================================================================
% (c) L. Kuncheva: Diversity Toolbox                                ^--^
% v.2.0 Nov 2011 -------------------------------------------------  \oo/
%
m = size(x,2);
Q = zeros(m); % preallocate for speed
for i = 1:m-1
   Q(i,i) = 1;
   for j = i+1:m
      C1 = x(:,i);
      C2 = x(:,j);
      a = sum(C1.*C2);
      b = sum(C1.*(1-C2));
      c = sum((1-C1).*C2);
      d = sum((1-C1).*(1-C2));
      if (a*d+b*c) == 0,
          Q(i,j) = 1;
      else
          Q(i,j) = (a*d-b*c)/(a*d+b*c);
      end
      Q(j,i) = Q(i,j);
   end
Q(m,m) = 1;
end

if size(x,2) == 2 % only 2 classifiers
    Q = Q(1,2); % return one single value
end
