function KW = kw(x)
% KW calculates the Kohavi-Wolpert non-pairwise diversity measure 
%    KW = KW(X) calculates the Kohavi-Wolpert variance (a non-pairwise 
%    diversity measure) of L classifier outputs. X is an array with N rows 
%    (data points) and L columns (classifiers in the ensemble). The entries 
%    of X are 0 for wrong classification and 1 for correct classification.
%
%   See also KAPPA, GENERALISED_DIVERSITY, COINCIDENCE_FAILURE_DIVERSITY, 
%   ENTROPY, DIFFICULTY
%

%========================================================================
% (c) L. Kuncheva: Diversity Toolbox                                ^--^
% v.2.0 Nov 2011 -------------------------------------------------  \oo/
%
[N,L] = size(x);
KW = 1/(N*L*L)*sum(sum(x,2).*(L-sum(x,2)));
