function K = kappa(x)
% KAPPA calculates the non-pairwise diversity measure kappa
%    K = KAPPA(X) calculates the non-pairwise diversity measure kappa of
%    L classifier outputs. X is an array with N rows (data points) and 
%    L columns (classifiers in the ensemble). The entries of X are 0 for 
%    wrong classification and 1 for correct classification.
%
%   See also KW, GENERALISED_DIVERSITY, COINCIDENCE_FAILURE_DIVERSITY,
%   ENTROPY, DIFFICULTY
%

%========================================================================
% (c) L. Kuncheva: Diversity Toolbox                                ^--^
% v.2.0 Nov 2011 -------------------------------------------------  \oo/

[~,L] = size(x);
p = mean(mean(x));
K = 1-L/((L-1)*p*(1-p))*kw(x); % needs the Kohavi-Wolpert measure
