function E = entropy(x)
% ENTROPY calculates the entropy non-pairwise diversity measure 
%    E = ENTROPY(X) calculates the non-pairwise entropy diversity 
%    measure of L classifier outputs. X is an array with N rows 
%    (data points) and L columns (classifiers in the ensemble). The 
%    entries of X are 0 for wrong classification and 1 for correct 
%    classification.
%
%   See also GENERALISED_DIVERSITY, COINCIDENCE_FAILURE_DIVERSITY, 
%   KAPPA, KW, DIFFICULTY
%

%========================================================================
% (c) L. Kuncheva: Diversity Toolbox                                ^--^
% v.2.0 Nov 2011 -------------------------------------------------  \oo/

[N,L] = size(x);
E = 1/(N*(L-ceil(L/2)))*sum(min(sum(x,2),L-sum(x,2)));
