function D = disagreement(x)
% DISAGREEMENT calculates the "disagreement" diversity measure 
%    D = DISAGREEMENT(X) calculates the "disagreement" diversity measure
%    for L classifier outputs. X is an array with N rows (data points) and 
%    L columns (classifiers in the ensemble). The entries of X  are 0 for 
%    wrong classification and 1 for correct classification. D is a square 
%    matrix of size L-by-L. If X contains only two columns, then D is a 
%    single value.
% 
%   See also QCALC, RHO, DOUBLE_FAULT
%

%========================================================================
% (c) L. Kuncheva: Diversity Toolbox                                ^--^
% v.2.0 Nov 2011 -------------------------------------------------  \oo/
%

m = size(x,2);
D = zeros(m); % preallocate for speed
for i = 1:m-1
   for j = i+1:m
      C1 = x(:,i);
      C2 = x(:,j);
      a = sum(C1.*C2);
      b = sum(C1.*(1-C2));
      c = sum((1-C1).*C2);
      d = sum((1-C1).*(1-C2));
      D(i,j) = (b+c)/(a+b+c+d);
      D(j,i) = D(i,j);
   end
end

if size(x,2) == 2 % only 2 classifiers
    D = D(1,2); % return one single value
end
