function theta = difficulty(x)
% DIFFICULTY calculates the "diffuclty" diversity measure  
%    THETA = DIFFICULTY(X) calculates the non-pairwise diversity measure 
%    "difficulty" for L classifier outputs. X is an array with N rows (data 
%    points) and L columns (classifiers in the ensemble). The entries of X 
%    are 0 for wrong classification and 1 for correct classification. R is 
%    a square matrix of size L-by-L. If X contains only two columns, then R 
%    is a single value. The measure is based on the distribution of correct 
%    votes (Hansen & Salomon, 1990). It represents a "Pattern of 
%    difficulty" for the ensemble in X.
% 
%   See also GENERALISED_DIVERSITY, COINCIDENCE_FAILURE_DIVERSITY, KAPPA, 
%   KW, ENTROPY
%

%========================================================================
% (c) L. Kuncheva: Diversity Toolbox                                ^--^
% v.2.0 Nov 2011 -------------------------------------------------  \oo/
%

[N,L] = size(x);
t = sum(x,2); % number of correct votes for each object
D = zeros(1,L+1);
for i = 0:L,
    D(i+1) = sum(t==i)/N;
end
ProportionCorrect = (0:L)/L;
mu = D*ProportionCorrect';
theta = (D*(ProportionCorrect.^2)' - mu^2);
    
