function CFD = coincidence_failure_diversity(x)
% COINCIDENCE_FAILURE_DIVERSITY calculates the CFD measure 
%    CFD = COINCIDENCE_FAILURE_DIVERSITY(X) calculates the non-pairwise 
%    diversity measure CFD of L classifier outputs (Partridge & 
%    Krzanowski). X is an array with N rows (data points) and L columns 
%    (classifiers in the ensemble). The entries of X are 0 for wrong 
%    classification and 1 for correct classification.
%
%   See also GENERALISED_DIVERSITY, KAPPA, KW, ENTROPY, DIFFICULTY
%

%========================================================================
% (c) L. Kuncheva: Diversity Toolbox                                ^--^
% v.2.0 Nov 2011 -------------------------------------------------  \oo/
%

[N,L] = size(x);
t = sum(x,2); % number of correct votes for each object
D = zeros(1,L+1);
for i = 0:L,
    D(i+1) = sum(t==i);
end
D = fliplr(D)/N;
% D is an array with the probabilities p_i that exactly
% i of the classifiers FAIL (!) for a randomly drawn object
i = 1:L;
if D(1) == 1,
    CFD = 0;
else
    CFD = sum((L-i).*D(2:L+1))/(L-1)/(1-D(1));
end

